function acc=CHfixedtau(tau,row,column,Y)

levR{1}=1/3*ones(1,3);
levC{1}=1/3*ones(1,3);

n=length(row);
t=tau;
for g=1:n
    ExpPayoffR=levR{1}*row{g}';
    [~,ind]=max(ExpPayoffR);
    levR{2}=zeros(1,3);
    levR{2}(ind)=1;
    ExpPayoffC=levC{1}*column{g};
    [~,ind]=max(ExpPayoffC);
    levC{2}=zeros(1,3);
    levC{2}(ind)=1;
    
    for k=2:7
        w=poisspdf(0:k-1,t)/sum(poisspdf(0:k-1,t));
        
        mixR=w(1).*levC{1};
        for j=2:k
            mixR=mixR+w(j)*levC{j};
        end
        
        ExpPayoffR=mixR*row{g}';
        [~,ind]=max(ExpPayoffR);
        levR{k+1}=zeros(1,3);
        levR{k+1}(ind)=1;
        
        mixC=w(1).*levR{1};
        for j=2:k
            mixC=mixC+w(j)*levR{j};
        end
        
        ExpPayoffC=mixC*column{g};
        [~,ind]=max(ExpPayoffC);
        levC{k+1}=zeros(1,3);
        levC{k+1}(ind)=1;
    end
    all(g,:)=poisspdf(0,t)*levR{1};
    for k=1:7
        all(g,:)=all(g,:)+poisspdf(k,t)*levR{k+1};
    end
end

predLK=zeros(1,n);
for g=1:n
    [~,predLK(g)]=max(all(g,:));
end

errLK=zeros(n,1);
for i=1:n
    if predLK(i)~=Y(i)
        errLK(i)=1;
    end
end

acc=1-mean(errLK);
